<?php
// login_action.php
session_start();
require 'db_connection.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var(trim($_POST['email'] ?? ''), FILTER_SANITIZE_EMAIL);
    $password = $_POST['password'] ?? '';

    // Check if the user exists and is active
    $stmt = $pdo->prepare("SELECT user_id, role_id, password_hash FROM users WHERE email = ? AND status = 'active'");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password_hash'])) {
        
        // Log the successful login in the audit trail
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $log_stmt = $pdo->prepare("INSERT INTO audit_logs (user_id, action, ip_address) VALUES (?, 'Dashboard_Login', ?)");
        $log_stmt->execute([$user['user_id'], $ip_address]);

        // Initialize the secure session
        $_SESSION['user_id'] = $user['user_id'];
        $_SESSION['role_id'] = $user['role_id']; 
        $_SESSION['logged_in'] = true;

        echo json_encode(['status' => 'success', 'redirect' => 'dashboard.php']);
        exit;
    } else {
        // Log the failed attempt
        $ip_address = $_SERVER['REMOTE_ADDR'];
        // We use a dummy ID or NULL if the email wasn't found, but for security, we just log the IP and email
        $log_stmt = $pdo->prepare("INSERT INTO audit_logs (guest_email, action, ip_address) VALUES (?, 'Failed_Dashboard_Login', ?)");
        $log_stmt->execute([$email, $ip_address]);

        echo json_encode(['status' => 'error', 'message' => 'Invalid email or password.']);
        exit;
    }
}
?>